/**
 * Utility
 * 
 * Ansammlung statischer Methoden ohne spezifische Klassenzugehrigkeit
 * 
 */


/**
 * Methode sgn(value) : int
 * 
 * 	Bestimmt das Vorzeichen von value und gibt es verkpft mit 1 zurck.
 * 	Javascript scheint dies nicht standardmig in der Math Biblithek zu haben, also selbst geschrieben
 * 
 * Parameter:
 * 
 * 	value {float} Wert dessen Vorzeichen bestimmt werden soll - funktioniert auch mit anderen numerischen Datentypen
 *
 *Rckgabewert:
 *
 *	{int} Gesuchtes Vorzeichen in Form von -1 bzw. +1
 *
 *Statische Methode ohne konkreten Klassenbezug
 *
 */
function sgn(value){
	if(value>0)return 1;
	else if(value<0)return -1;
	else return 0;
}

/**
 * Methode degToRad(deg) : float
 * 
 * 	Umrechnung eines Winkels vom Gradma ins Bogenma
 * 
 * Parameter:
 * 
 * 	deg {float} WInkel im Gradma der umgerechnet werden soll
 * 
 * Rckgabewert:
 * 
 * {float} Der Winkl im Gradma
 * 
 * Statische Methode ohne konkreten Klassenbezug
 * 
 */
function degToRad(deg) {
	return deg * Math.PI / 180;
}
    
/**
 * Methode itemDistance(item1, item2) : float
 * 
 * 	Berechnung der Distanz, die zwischen zwei durch Ortsvektoren beschriebenen Punkten liegt
 *  - euklidische Norm des Differenzvektors
 * 
 * Parameter:
 * 
 *	item1 {float[]} Erster Punkt
 * 	item2 {float[]} Zweiter Punkt
 * 
 * Rckgabewert:
 * 
 * 	{float} Distanz zwischen den beiden Punkten
 * 
 * Statische Methode ohne konkreten Klassenbezug
 * 
 */
function itemDistance(item1, item2){
	//Errechnet die Distanz zwischen zwei Punkten (euklidische Norm)
	return Math.sqrt(Math.pow((item1[0] - item2[0]),2) + Math.pow((item1[1] - item2[1]),2) + Math.pow((item1[2] - item2[2]),2));
};

/**
 * Methode calculateFPS() : void
 * 
 * 	Ermittlung der gerenderten Bilder Pro Sekunde - solange die nchste Sekunde noch nich erreicht wurde,
 * 	wird einfach der die globale Variable fpscounter jewails um 1 erhht
 * 
 * Statische Methode ohne konkreten Klassenbezug
 * 
 */
function calculateFPS(){
	//ntig zur Anzeige der FPS - keine wirklich elegante Lsung
	timenow = Math.floor(new Date().getTime() / 1000);
	if(timenow > fpstimer){
    	 document.getElementById('FPS').value = fpscounter;
     	fpscounter = 1;
     	fpstimer = timenow;
	}
	else{
    	 fpscounter++;
	}	 
};
 
/**
 * Methode getRotationMatrix (naxis, angle) : float[]
 * 
 * 	Generiert eine 3x3 Rotationsmatrix zur Drehung um die normierte Drehachse naxis mit Winkel angle
 * 
 * 	--> Bender/Brill - Computergrafik (2003)
 * 
 * Paramater:
 * 
 * 	naxis {float[3]} normierte Drehachse
 * 	angle {float[3]} Drehwinkel im Gradma
 * 
 * Rckgabewert:
 * 
 * 	{float[9]} gewnschte Rotationsmatix - in Form eines eindimensionalen Feldes
 * 
 * Statische Methode ohne konreten Klassenbezug
 * 
 */
function getRotationMatrix(naxis, angle){
	 
	var s = Math.sin(degToRad(angle));
	var c = Math.cos(degToRad(angle));
	var t = 1 - c;
 
	var rotM = [];
	rotM[0] = t * Math.pow(naxis[0], 2) + c;
	rotM[1] = t * naxis[0] * naxis[1] - s * naxis[2];
	rotM[2] = t * naxis[0] * naxis[2] + s * naxis[1];
	 
	rotM[3] = t * naxis[0] * naxis[1] + s * naxis[2];
	rotM[4] = t * Math.pow(naxis[1], 2) + c;
	rotM[5] = t * naxis[1] * naxis[2] - s * naxis[0];
	 
	rotM[6] = t * naxis[0] * naxis[2] - s * naxis[1];
	rotM[7] = t * naxis[1] * naxis[2] - s * naxis[0];
	rotM[8] = t * Math.pow(naxis[2], 2) + c;
	
	return rotM;
}
 